/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmBlock;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_809;
import net.minecraft.class_918;

public class ArmRenderer
extends KineticTileEntityRenderer {
    public ArmRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float pt, class_4587 ms, class_4597 buffer, int light, int overlay) {
        int color;
        float headAngle;
        float upperArmAngle;
        float lowerArmAngle;
        float baseAngle;
        boolean rave;
        super.renderSafe(te, pt, ms, buffer, light, overlay);
        ArmTileEntity arm = (ArmTileEntity)te;
        class_1799 item = arm.heldItem;
        boolean hasItem = !item.method_7960();
        boolean usingFlywheel = Backend.canUseInstancing((class_1937)te.method_10997());
        if (usingFlywheel && !hasItem) {
            return;
        }
        class_918 itemRenderer = class_310.method_1551().method_1480();
        boolean isBlockItem = hasItem && item.method_7909() instanceof class_1747 && itemRenderer.method_4019(item, te.method_10997(), null, 0).method_4712();
        class_4588 builder = buffer.getBuffer(class_1921.method_23577());
        class_2680 blockState = te.method_11010();
        class_4587 msLocal = new class_4587();
        TransformStack msr = TransformStack.cast((class_4587)msLocal);
        boolean bl = rave = arm.phase == ArmTileEntity.Phase.DANCING && te.getSpeed() != 0.0f;
        if (rave) {
            float renderTick = AnimationTickHolder.getRenderTime((class_1936)te.method_10997()) + (float)(te.hashCode() % 64);
            baseAngle = renderTick * 10.0f % 360.0f;
            lowerArmAngle = class_3532.method_16439((float)((class_3532.method_15374((float)(renderTick / 4.0f)) + 1.0f) / 2.0f), (float)-45.0f, (float)15.0f);
            upperArmAngle = class_3532.method_16439((float)((class_3532.method_15374((float)(renderTick / 8.0f)) + 1.0f) / 4.0f), (float)-45.0f, (float)95.0f);
            headAngle = -lowerArmAngle;
            color = Color.rainbowColor(AnimationTickHolder.getTicks() * 100).getRGB();
        } else {
            baseAngle = arm.baseAngle.getValue(pt);
            lowerArmAngle = arm.lowerArmAngle.getValue(pt) - 135.0f;
            upperArmAngle = arm.upperArmAngle.getValue(pt) - 90.0f;
            headAngle = arm.headAngle.getValue(pt);
            color = 0xFFFFFF;
        }
        msr.centre();
        if (((Boolean)blockState.method_11654((class_2769)ArmBlock.CEILING)).booleanValue()) {
            msr.rotateX(180.0);
        }
        if (usingFlywheel) {
            this.doItemTransforms(msr, baseAngle, lowerArmAngle, upperArmAngle, headAngle);
        } else {
            this.renderArm(builder, ms, msLocal, msr, blockState, color, baseAngle, lowerArmAngle, upperArmAngle, headAngle, hasItem, isBlockItem, light);
        }
        if (hasItem) {
            ms.method_22903();
            float itemScale = isBlockItem ? 0.5f : 0.625f;
            msr.rotateX(90.0);
            msLocal.method_22904(0.0, -0.25, 0.0);
            msLocal.method_22905(itemScale, itemScale, itemScale);
            ms.method_23760().method_23761().method_22672(msLocal.method_23760().method_23761());
            itemRenderer.method_23178(item, class_809.class_811.field_4319, light, overlay, ms, buffer, 0);
            ms.method_22909();
        }
    }

    private void renderArm(class_4588 builder, class_4587 ms, class_4587 msLocal, TransformStack msr, class_2680 blockState, int color, float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle, boolean hasItem, boolean isBlockItem, int light) {
        SuperByteBuffer base = CachedBufferer.partial(AllBlockPartials.ARM_BASE, blockState).light(light);
        SuperByteBuffer lowerBody = CachedBufferer.partial(AllBlockPartials.ARM_LOWER_BODY, blockState).light(light);
        SuperByteBuffer upperBody = CachedBufferer.partial(AllBlockPartials.ARM_UPPER_BODY, blockState).light(light);
        SuperByteBuffer head = CachedBufferer.partial(AllBlockPartials.ARM_HEAD, blockState).light(light);
        SuperByteBuffer claw = CachedBufferer.partial(AllBlockPartials.ARM_CLAW_BASE, blockState).light(light);
        SuperByteBuffer clawGrip = CachedBufferer.partial(AllBlockPartials.ARM_CLAW_GRIP, blockState);
        ArmRenderer.transformBase(msr, baseAngle);
        base.transform(msLocal).renderInto(ms, builder);
        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        lowerBody.color(color).transform(msLocal).renderInto(ms, builder);
        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        upperBody.color(color).transform(msLocal).renderInto(ms, builder);
        ArmRenderer.transformHead(msr, headAngle);
        head.transform(msLocal).renderInto(ms, builder);
        ArmRenderer.transformClaw(msr);
        claw.transform(msLocal).renderInto(ms, builder);
        for (int flip : Iterate.positiveAndNegative) {
            msLocal.method_22903();
            ArmRenderer.transformClawHalf(msr, hasItem, isBlockItem, flip);
            clawGrip.light(light).transform(msLocal).renderInto(ms, builder);
            msLocal.method_22909();
        }
    }

    private void doItemTransforms(TransformStack msr, float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle) {
        ArmRenderer.transformBase(msr, baseAngle);
        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        ArmRenderer.transformHead(msr, headAngle);
        ArmRenderer.transformClaw(msr);
    }

    public static void transformClawHalf(TransformStack msr, boolean hasItem, boolean isBlockItem, int flip) {
        msr.translate(0.0, (double)(flip * 3) / 16.0, -0.0625);
        msr.rotateX((double)(flip * (hasItem ? (isBlockItem ? 0 : -35) : 0)));
    }

    public static void transformClaw(TransformStack msr) {
        msr.translate(0.0, 0.0, -0.25);
    }

    public static void transformHead(TransformStack msr, float headAngle) {
        msr.translate(0.0, 0.6875, -0.6875);
        msr.rotateX((double)headAngle);
    }

    public static void transformUpperArm(TransformStack msr, float upperArmAngle) {
        msr.translate(0.0, 0.75, 0.75);
        msr.rotateX((double)upperArmAngle);
    }

    public static void transformLowerArm(TransformStack msr, float lowerArmAngle) {
        msr.translate(0.0, 0.0625, -0.125);
        msr.rotateX((double)lowerArmAngle);
        msr.translate(0.0, -0.0625, 0.0);
    }

    public static void transformBase(TransformStack msr, float baseAngle) {
        msr.translate(0.0, 0.25, 0.0);
        msr.rotateY((double)baseAngle);
    }

    public boolean shouldRenderOffScreen(KineticTileEntity te) {
        return true;
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticTileEntity te, class_2680 state) {
        return CachedBufferer.partial(AllBlockPartials.ARM_COG, state);
    }
}

